//
//  CROnViewEditor.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 04/04/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRGraphicsObject.h"
#import "CRSceneRenderBreak.h"

@class CRInplaceEditorController;

//////////////////////////////////////////////////////////////////////
// Basic On-View editor class, any custom editor must inherite this one
//////////////////////////////////////////////////////////////////////
@interface CRInplaceEditor : CRGraphicsObjectBase
{
@protected
	id assigned		rootObject;			// representing object
	id assigned		rootController;		// root controller
	CRRenderMode	renderMode;			// subj
	BOOL			draggingMode;		// signals whether the view is dragged and should disable some visuals
}

@property (nonatomic, assign)	id				rootObject;
@property (nonatomic, assign)	id				rootController;
@property (nonatomic, assign)	CRRenderMode	renderMode;
@property (nonatomic, assign)	BOOL			draggingMode;
@property (nonatomic, readonly) NSSize			spacing;

// Initialize
- (void)initialize;
- (void)connect;
- (void)disconnect;
- (void)prepare;

// Specials
- (CGRect)adjustExtentRect:(CGRect)extent inBounds:(CGRect)boundsRect;

// Values
- (IBAction)setDefaults:(id)sender;

@end